
<?php
// Start session and check authentication
require '../config/check.php';
?>

<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="output.css" rel="stylesheet">
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          colors: {
            primary: {
              DEFAULT: '#fbbb01',
              100: '#fef4d5',
              200: '#fde8ab',
              300: '#fbdd81',
              400: '#fad157',
              500: '#fbbb01',
              600: '#c99601',
              700: '#977001',
              800: '#644b00',
              900: '#322500',
            }
          }
        }
      }
    }
  </script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    body {
      font-family: 'Poppins', sans-serif;
      transition: background-color 0.3s ease;
    }
    /* Custom scrollbar */
    ::-webkit-scrollbar {
      width: 6px;
    }
    ::-webkit-scrollbar-track {
      background: #f1f1f1;
    }
    ::-webkit-scrollbar-thumb {
      background: #fbbb01;
      border-radius: 3px;
    }
    .dark ::-webkit-scrollbar-track {
      background: #1f2937;
    }
    .dark ::-webkit-scrollbar-thumb {
      background: #c99601;
    }
    .sidebar {
      transition: all 0.3s ease;
    }
    @media (max-width: 1023px) {
      .sidebar {
        transform: translateX(-100%);
        position: fixed;
        z-index: 50;
        height: 100vh;
      }
      .sidebar.active {
        transform: translateX(0);
      }
    }
    /* Profile dropdown */
    .profile-dropdown {
      display: none;
      position: absolute;
      right: 1rem;
      top: 4rem;
      width: 200px;
      background: white;
      border-radius: 0.5rem;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      z-index: 50;
    }
    .dark .profile-dropdown {
      background: #1f2937;
      border: 1px solid #374151;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.3), 0 2px 4px -1px rgba(0, 0, 0, 0.2);
    }
    .profile-dropdown.active {
      display: block;
    }
    /* Bottom nav */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      display: flex;
      justify-content: space-around;
      padding: 0.75rem 0;
      border-top: 1px solid #e5e7eb;
      z-index: 40;
    }
    .dark .bottom-nav {
      background: #111827;
      border-top: 1px solid #374151;
    }
    .bottom-nav-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
    }
    .bottom-nav-icon {
      font-size: 1.5rem;
      margin-bottom: 0.25rem;
    }
    .bottom-nav-text {
      font-size: 0.75rem;
    }
    /* Main content padding adjustment for mobile */
    .main-content {
      padding-bottom: 4rem; /* Space for bottom nav */
    }
    @media (min-width: 1024px) {
      .main-content {
        padding-bottom: 0;
      }
      .bottom-nav {
        display: none;
      }
      .sidebar-toggle {
        display: none !important;
      }
    }
    /* Admin specific styles */
    .stats-card {
      transition: all 0.3s ease;
    }
    .stats-card:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }
    .user-table {
      width: 100%;
      border-collapse: collapse;
    }
    .user-table th, .user-table td {
      padding: 12px 15px;
      text-align: left;
      border-bottom: 1px solid #e5e7eb;
    }
    .dark .user-table th, .dark .user-table td {
      border-bottom: 1px solid #374151;
    }
    .user-table th {
      background-color: #f9fafb;
      font-weight: 600;
    }
    .dark .user-table th {
      background-color: #1f2937;
    }
    .status-badge {
      padding: 4px 8px;
      border-radius: 12px;
      font-size: 12px;
      font-weight: 500;
    }
    .status-active {
      background-color: #dcfce7;
      color: #166534;
    }
    .dark .status-active {
      background-color: #166534;
      color: #dcfce7;
    }
    .status-inactive {
      background-color: #fee2e2;
      color: #991b1b;
    }
    .dark .status-inactive {
      background-color: #991b1b;
      color: #fee2e2;
    }
    .status-pending {
      background-color: #fef9c3;
      color: #854d0e;
    }
    .dark .status-pending {
      background-color: #854d0e;
      color: #fef9c3;
    }
    .search-input {
      transition: all 0.3s ease;
    }
    .search-input:focus {
      border-color: #fbbb01;
      box-shadow: 0 0 0 3px rgba(251, 187, 1, 0.2);
    }
  </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900">
<div class="flex min-h-screen">
  <?php include 'include/sidebar.php'; ?>
<?php include 'include/navbar.php'; ?>