<?php include 'include/header.php'; ?>

<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
  <!-- Stats Cards -->
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
    <div class="stats-card bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
      <div class="flex justify-between items-start">
        <div>
          <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Total Users</p>
          <p class="text-2xl font-bold text-gray-800 dark:text-white">2,845</p>
        </div>
        <div class="w-12 h-12 bg-blue-50 dark:bg-blue-900/30 rounded-full flex items-center justify-center">
          <i class="fas fa-users text-blue-500 dark:text-blue-400 text-xl"></i>
        </div>
      </div>
      <p class="text-xs text-green-500 dark:text-green-400 mt-2"><i class="fas fa-arrow-up mr-1"></i> 12.5% from last month</p>
    </div>
    
    <div class="stats-card bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
      <div class="flex justify-between items-start">
        <div>
          <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Active Vendors</p>
          <p class="text-2xl font-bold text-gray-800 dark:text-white">48</p>
        </div>
        <div class="w-12 h-12 bg-green-50 dark:bg-green-900/30 rounded-full flex items-center justify-center">
          <i class="fas fa-store text-green-500 dark:text-green-400 text-xl"></i>
        </div>
      </div>
      <p class="text-xs text-green-500 dark:text-green-400 mt-2"><i class="fas fa-arrow-up mr-1"></i> 3 new this month</p>
    </div>
    
    <div class="stats-card bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
      <div class="flex justify-between items-start">
        <div>
          <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Pending Approvals</p>
          <p class="text-2xl font-bold text-gray-800 dark:text-white">12</p>
        </div>
        <div class="w-12 h-12 bg-yellow-50 dark:bg-yellow-900/30 rounded-full flex items-center justify-center">
          <i class="fas fa-clock text-yellow-500 dark:text-yellow-400 text-xl"></i>
        </div>
      </div>
      <p class="text-xs text-red-500 dark:text-red-400 mt-2"><i class="fas fa-arrow-down mr-1"></i> 2 resolved today</p>
    </div>
    
    <div class="stats-card bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
      <div class="flex justify-between items-start">
        <div>
          <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Transactions Today</p>
          <p class="text-2xl font-bold text-gray-800 dark:text-white">1,245</p>
        </div>
        <div class="w-12 h-12 bg-primary-50 dark:bg-primary-900/30 rounded-full flex items-center justify-center">
          <i class="fas fa-exchange-alt text-primary-500 dark:text-primary-400 text-xl"></i>
        </div>
      </div>
      <p class="text-xs text-green-500 dark:text-green-400 mt-2"><i class="fas fa-arrow-up mr-1"></i> 24.7% from yesterday</p>
    </div>
  </div>

  <!-- User Management Section -->
  <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
    <div class="flex flex-col md:flex-row md:justify-between md:items-center mb-6">
      <h3 class="text-lg font-semibold dark:text-white mb-4 md:mb-0">Manage Users</h3>
      <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-3">
        <div class="relative">
          <input type="text" placeholder="Search users..." class="search-input pl-10 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:text-white">
          <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
        </div>
        <button class="bg-primary-500 hover:bg-primary-600 text-white px-4 py-2 rounded-lg text-sm font-medium flex items-center justify-center">
          <i class="fas fa-plus mr-2"></i> Add User
        </button>
      </div>
    </div>
    
    <!-- Tabs -->
    <div class="border-b border-gray-200 dark:border-gray-700 mb-6">
      <ul class="flex flex-wrap -mb-px">
        <li class="mr-2">
          <a href="#" class="inline-block p-4 border-b-2 border-primary-500 rounded-t-lg text-primary-500 dark:text-primary-400 dark:border-primary-400">All Users</a>
        </li>
        <li class="mr-2">
          <a href="#" class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300">Students</a>
        </li>
        <li class="mr-2">
          <a href="#" class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300">Vendors</a>
        </li>
        <li class="mr-2">
          <a href="#" class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300">Admins</a>
        </li>
        <li>
          <a href="#" class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300">Pending</a>
        </li>
      </ul>
    </div>
    
    <!-- Users Table -->
    <div class="overflow-x-auto">
      <table class="user-table w-full">
        <thead>
          <tr>
            <th class="dark:text-white">User ID</th>
            <th class="dark:text-white">Name</th>
            <th class="dark:text-white">Email</th>
            <th class="dark:text-white">Role</th>
            <th class="dark:text-white">Status</th>
            <th class="dark:text-white">Actions</th>
          </tr>
        </thead>
        <tbody>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="dark:text-white">STU-2023-001</td>
            <td class="dark:text-white">John Smith</td>
            <td class="dark:text-white">john.smith@athenian.edu</td>
            <td class="dark:text-white">Student</td>
            <td><span class="status-badge status-active">Active</span></td>
            <td>
              <button class="text-primary-500 hover:text-primary-700 dark:hover:text-primary-400 mr-2">
                <i class="fas fa-edit"></i>
              </button>
              <button class="text-red-500 hover:text-red-700 dark:hover:text-red-400">
                <i class="fas fa-trash-alt"></i>
              </button>
            </td>
          </tr>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="dark:text-white">VEN-2023-045</td>
            <td class="dark:text-white">Campus Cafe</td>
            <td class="dark:text-white">cafe@athenian.edu</td>
            <td class="dark:text-white">Vendor</td>
            <td><span class="status-badge status-active">Active</span></td>
            <td>
              <button class="text-primary-500 hover:text-primary-700 dark:hover:text-primary-400 mr-2">
                <i class="fas fa-edit"></i>
              </button>
              <button class="text-red-500 hover:text-red-700 dark:hover:text-red-400">
                <i class="fas fa-trash-alt"></i>
              </button>
            </td>
          </tr>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="dark:text-white">STU-2023-112</td>
            <td class="dark:text-white">Sarah Johnson</td>
            <td class="dark:text-white">sarah.j@athenian.edu</td>
            <td class="dark:text-white">Student</td>
            <td><span class="status-badge status-inactive">Inactive</span></td>
            <td>
              <button class="text-primary-500 hover:text-primary-700 dark:hover:text-primary-400 mr-2">
                <i class="fas fa-edit"></i>
              </button>
              <button class="text-red-500 hover:text-red-700 dark:hover:text-red-400">
                <i class="fas fa-trash-alt"></i>
              </button>
            </td>
          </tr>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="dark:text-white">VEN-2023-078</td>
            <td class="dark:text-white">Book Store</td>
            <td class="dark:text-white">books@athenian.edu</td>
            <td class="dark:text-white">Vendor</td>
            <td><span class="status-badge status-pending">Pending</span></td>
            <td>
              <button class="text-primary-500 hover:text-primary-700 dark:hover:text-primary-400 mr-2">
                <i class="fas fa-edit"></i>
              </button>
              <button class="text-red-500 hover:text-red-700 dark:hover:text-red-400">
                <i class="fas fa-trash-alt"></i>
              </button>
            </td>
          </tr>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
            <td class="dark:text-white">ADM-2023-001</td>
            <td class="dark:text-white">Admin User</td>
            <td class="dark:text-white">admin@athenian.edu</td>
            <td class="dark:text-white">Administrator</td>
            <td><span class="status-badge status-active">Active</span></td>
            <td>
              <button class="text-primary-500 hover:text-primary-700 dark:hover:text-primary-400 mr-2">
                <i class="fas fa-edit"></i>
              </button>
              <button class="text-red-500 hover:text-red-700 dark:hover:text-red-400">
                <i class="fas fa-trash-alt"></i>
              </button>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    
    <!-- Pagination -->
    <div class="flex flex-col sm:flex-row items-center justify-between mt-6 space-y-3 sm:space-y-0">
      <div class="text-sm text-gray-500 dark:text-gray-400">
        Showing <span class="font-medium">1</span> to <span class="font-medium">5</span> of <span class="font-medium">24</span> entries
      </div>
      <div class="flex space-x-2">
        <button class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 disabled:opacity-50" disabled>
          Previous
        </button>
        <button class="px-3 py-1 bg-primary-500 text-white rounded-md text-sm font-medium hover:bg-primary-600">
          1
        </button>
        <button class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
          2
        </button>
        <button class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
          3
        </button>
        <button class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
          Next
        </button>
      </div>
    </div>
  </div>
</main>


<?php include 'include/footer.php'; ?>