<?php


if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    error_log("Unauthorized access attempt - no admin_logged_in session");
    $_SESSION['redirect_message'] = "You must be logged in to access that page";
    header("Location: admin-login.php");
    exit();
}

// Verify session data is complete
if (!isset($_SESSION['admin_id']) || !isset($_SESSION['admin_email'])) {
    error_log("Incomplete session data - missing user_id or email");
    session_destroy();
    header("Location: admin-login.php");
    exit();
}

// Database connection
require '../config/conn.php';

// Fetch admin details from database
$admin_id = $_SESSION['admin_id'];
$stmt = $conn->prepare("SELECT `id`, `admin_id`, `full_name`, `email`, `phone`, `gender`, `role`, `last_login`, `created_at` FROM `admins` WHERE `admin_id` = ?");
$stmt->bind_param("s", $admin_id);
$stmt->execute();
$result = $stmt->get_result();
$admin = $result->fetch_assoc();

if (!$admin) {
    error_log("Admin not found in database - possible data inconsistency");
    $_SESSION['error_message'] = "Your account could not be found";
    header("Location: admin-login.php");
    exit();
}
?>

<?php include 'include/header.php'; ?>


<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
    <div class="max-w-4xl mx-auto">
        <!-- Profile Header -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
            <div class="flex flex-col md:flex-row items-start md:items-center gap-6">
                <div class="w-24 h-24 rounded-full bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center">
                    <i class="fas fa-user text-primary-500 dark:text-primary-400 text-3xl"></i>
                </div>
                <div class="flex-1">
                    <h2 class="text-2xl font-bold text-gray-800 dark:text-white"><?php echo htmlspecialchars($admin['full_name']); ?></h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-2"><?php echo htmlspecialchars($admin['role']); ?> Administrator</p>
                    <div class="flex flex-wrap gap-2">
                        <span class="px-3 py-1 bg-green-100 dark:bg-green-900/30 text-green-800 dark:text-green-200 rounded-full text-xs font-medium">
                            <i class="fas fa-circle text-green-500 dark:text-green-400 mr-1"></i> Active
                        </span>
                        <span class="px-3 py-1 bg-blue-100 dark:blue-green-900/30 text-blue-800 dark:text-blue-200 rounded-full text-xs font-medium">
                            <i class="fas fa-shield-alt text-blue-500 dark:text-blue-400 mr-1"></i> Verified
                        </span>
                    </div>
                </div>
                <button class="bg-primary-500 hover:bg-primary-600 text-white px-4 py-2 rounded-lg text-sm font-medium flex items-center">
                    <i class="fas fa-edit mr-2"></i> Edit Profile
                </button>
            </div>
        </div>

        <!-- Profile Details -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <!-- Personal Information -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Personal Information</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Full Name</p>
                        <p class="dark:text-white"><?php echo htmlspecialchars($admin['full_name']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Admin ID</p>
                        <p class="dark:text-white"><?php echo htmlspecialchars($admin['admin_id']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Email Address</p>
                        <p class="dark:text-white"><?php echo htmlspecialchars($admin['email']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Phone Number</p>
                        <p class="dark:text-white"><?php echo $admin['phone'] ? htmlspecialchars($admin['phone']) : 'Not provided'; ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Gender</p>
                        <p class="dark:text-white"><?php echo $admin['gender'] ? htmlspecialchars($admin['gender']) : 'Not specified'; ?></p>
                    </div>
                </div>
            </div>

            <!-- Account Information -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-semibold dark:text-white mb-4">Account Information</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Role</p>
                        <p class="dark:text-white"><?php echo htmlspecialchars($admin['role']); ?> Administrator</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Account Created</p>
                        <p class="dark:text-white"><?php echo date('F j, Y', strtotime($admin['created_at'])); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Last Login</p>
                        <p class="dark:text-white">
                            <?php echo $admin['last_login'] ? date('F j, Y g:i a', strtotime($admin['last_login'])) : 'Never logged in'; ?>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Status</p>
                        <p class="dark:text-white">Active</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Verification</p>
                        <p class="dark:text-white">Verified</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Security Section -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
            <h3 class="text-lg font-semibold dark:text-white mb-4">Security</h3>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <div>
                        <p class="font-medium dark:text-white">Password</p>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Last changed 3 months ago</p>
                    </div>
                    <button class="bg-primary-500 hover:bg-primary-600 text-white px-4 py-2 rounded-lg text-sm font-medium">
                        Change Password
                    </button>
                </div>
                <div class="flex justify-between items-center">
                    <div>
                        <p class="font-medium dark:text-white">Two-Factor Authentication</p>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Add an extra layer of security</p>
                    </div>
                    <button class="bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-800 dark:text-white px-4 py-2 rounded-lg text-sm font-medium">
                        Enable 2FA
                    </button>
                </div>
            </div>
        </div>

        <!-- Activity Log -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold dark:text-white">Recent Activity</h3>
                <a href="#" class="text-primary-500 hover:text-primary-600 dark:hover:text-primary-400 text-sm font-medium">View All</a>
            </div>
            <div class="space-y-4">
                <div class="flex items-start gap-3">
                    <div class="w-10 h-10 rounded-full bg-blue-50 dark:bg-blue-900/30 flex items-center justify-center mt-1">
                        <i class="fas fa-user text-blue-500 dark:text-blue-400"></i>
                    </div>
                    <div>
                        <p class="dark:text-white">Logged in to the system</p>
                        <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo date('F j, Y g:i a'); ?></p>
                    </div>
                </div>
                <div class="flex items-start gap-3">
                    <div class="w-10 h-10 rounded-full bg-green-50 dark:bg-green-900/30 flex items-center justify-center mt-1">
                        <i class="fas fa-user-edit text-green-500 dark:text-green-400"></i>
                    </div>
                    <div>
                        <p class="dark:text-white">Updated user profile</p>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Yesterday at 3:45 PM</p>
                    </div>
                </div>
                <div class="flex items-start gap-3">
                    <div class="w-10 h-10 rounded-full bg-purple-50 dark:bg-purple-900/30 flex items-center justify-center mt-1">
                        <i class="fas fa-lock text-purple-500 dark:text-purple-400"></i>
                    </div>
                    <div>
                        <p class="dark:text-white">Changed password</p>
                        <p class="text-sm text-gray-500 dark:text-gray-400">3 days ago</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'include/footer.php'; ?>