<?php include 'include/header.php'; ?>

<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
  <!-- Stats Cards -->
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
    <!-- Your stats cards here (same as before) -->
  </div>

  <!-- Vendor Management Section -->
  <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 mb-6">
    <div class="flex flex-col md:flex-row md:justify-between md:items-center mb-6">
      <h3 class="text-lg font-semibold dark:text-white mb-4 md:mb-0">Manage Vendors</h3>
      <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-3">
        <form method="get" action="" class="relative">
          <input type="text" name="search" placeholder="Search vendors..." 
                 value="<?= htmlspecialchars($_GET['search'] ?? '') ?>" 
                 class="search-input pl-10 pr-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:text-white">
          <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
        </form>
      </div>
    </div>
    
    <!-- Tabs -->
    <div class="border-b border-gray-200 dark:border-gray-700 mb-6">
      <ul class="flex flex-wrap -mb-px" id="vendor-tabs">
        <li class="mr-2">
          <a href="?status=all<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
             class="inline-block p-4 border-b-2 <?= (!isset($_GET['status']) || $_GET['status'] === 'all') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
            All Vendors
          </a>
        </li>
        <li class="mr-2">
          <a href="?status=pending<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
             class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'pending') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
            Pending
          </a>
        </li>
        <li class="mr-2">
          <a href="?status=disapproved<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
             class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'disapproved') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
            Disapproved
          </a>
        </li>
        <li class="mr-2">
          <a href="?status=approved<?= isset($_GET['search']) ? '&search=' . htmlspecialchars($_GET['search']) : '' ?>" 
             class="inline-block p-4 border-b-2 <?= (isset($_GET['status']) && $_GET['status'] === 'approved') ? 'border-primary-500 text-primary-500 dark:text-primary-400 dark:border-primary-400' : 'border-transparent' ?> rounded-t-lg">
            Approved
          </a>
        </li>
      </ul>
    </div>
    
    <!-- Vendors Table -->
    <div class="overflow-x-auto">
      <table class="w-full" id="vendors-table">
        <thead>
          <tr>
            <th class="text-left py-3 px-4 dark:text-white">Vendor ID</th>
            <th class="text-left py-3 px-4 dark:text-white">Business Name</th>
            <th class="text-left py-3 px-4 dark:text-white">Email</th>
            <th class="text-left py-3 px-4 dark:text-white">Business Type</th>
            <th class="text-left py-3 px-4 dark:text-white">Status</th>
            <th class="text-left py-3 px-4 dark:text-white">Actions</th>
          </tr>
        </thead>
        <tbody id="vendors-table-body">
          <?php
          ob_start();
          // Get vendor data based on current filters
          $status = $_GET['status'] ?? 'all';
          $search = $_GET['search'] ?? '';
          $page = max(1, intval($_GET['page'] ?? 1));
          $perPage = 10;
          $offset = ($page - 1) * $perPage;
          
          // Build query
          $where = [];
          $params = [];
          $types = '';
          
          if ($status === 'approved') {
              $where[] = "is_approved = 1";
          } elseif ($status === 'pending') {
              $where[] = "is_approved = 0 AND is_verified = 1";
          } elseif ($status === 'disapproved') {
              $where[] = "is_approved = -1";
          }
          
          if ($search) {
              $where[] = "(business_name LIKE ? OR email LIKE ? OR vendor_id LIKE ?)";
              $searchTerm = "%$search%";
              $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
              $types .= 'sss';
          }
          
          $whereClause = $where ? "WHERE " . implode(" AND ", $where) : "";
          
          // Get total count
          $countQuery = "SELECT COUNT(*) FROM vendors $whereClause";
          if ($params) {
              $stmt = mysqli_prepare($conn, $countQuery);
              mysqli_stmt_bind_param($stmt, $types, ...$params);
              mysqli_stmt_execute($stmt);
              $result = mysqli_stmt_get_result($stmt);
          } else {
              $result = mysqli_query($conn, $countQuery);
          }
          $total = mysqli_fetch_row($result)[0];
          
          // Get paginated results
          $query = "SELECT id, vendor_id, business_name, email, phone, business_type, is_verified, is_approved 
                    FROM vendors $whereClause 
                    ORDER BY created_at DESC 
                    LIMIT ? OFFSET ?";
          
          $types .= 'ii';
          $params[] = $perPage;
          $params[] = $offset;
          
          $stmt = mysqli_prepare($conn, $query);
          mysqli_stmt_bind_param($stmt, $types, ...$params);
          mysqli_stmt_execute($stmt);
          $result = mysqli_stmt_get_result($stmt);
          
          if (mysqli_num_rows($result) === 0): ?>
            <tr>
              <td colspan="6" class="text-center py-4 text-gray-500 dark:text-gray-400">No vendors found</td>
            </tr>
          <?php else: 
            while ($vendor = mysqli_fetch_assoc($result)): ?>
              <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['vendor_id']) ?></td>
                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['business_name']) ?></td>
                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['email']) ?></td>
                <td class="py-3 px-4 dark:text-white"><?= htmlspecialchars($vendor['business_type']) ?></td>
                <td class="py-3 px-4">
                  <?php if ($vendor['is_approved'] == '1'): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">Approved</span>
                  <?php elseif ($vendor['is_approved'] == '0' && $vendor['is_verified'] == '1'): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200">Pending</span>
                  <?php elseif ($vendor['is_approved'] == '-1'): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">Disapproved</span>
                  <?php else: ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">Unverified</span>
                  <?php endif; ?>
                </td>
                <td class="py-3 px-4">
                  <div class="flex space-x-2">
                    <a href="?action=view&id=<?= $vendor['id'] ?>" class="text-blue-500 hover:text-blue-700 dark:hover:text-blue-400" title="View">
                      <i class="fas fa-eye"></i>
                    </a>
                    <?php if ($vendor['is_approved'] != '1'): ?>
                      <a href="?action=approve&id=<?= $vendor['id'] ?>" class="text-green-500 hover:text-green-700 dark:hover:text-green-400" title="Approve">
                        <i class="fas fa-check"></i>
                      </a>
                    <?php endif; ?>
                    <?php if ($vendor['is_approved'] != '-1'): ?>
                      <a href="?action=disapprove&id=<?= $vendor['id'] ?>" class="text-yellow-500 hover:text-yellow-700 dark:hover:text-yellow-400" title="Disapprove">
                        <i class="fas fa-ban"></i>
                      </a>
                    <?php endif; ?>
                    <?php if ($vendor['is_approved'] == '1' || $vendor['is_approved'] == '-1'): ?>
                      <a href="?action=reset&id=<?= $vendor['id'] ?>" class="text-blue-500 hover:text-blue-700 dark:hover:text-blue-400" title="Reset to Pending">
                        <i class="fas fa-undo"></i>
                      </a>
                    <?php endif; ?>
                    <a href="?action=delete&id=<?= $vendor['id'] ?>" onclick="return confirm('Are you sure you want to delete this vendor?')" class="text-red-500 hover:text-red-700 dark:hover:text-red-400" title="Delete">
                      <i class="fas fa-trash-alt"></i>
                    </a>
                  </div>
                </td>
              </tr>
            <?php endwhile;
          endif; ?>
        </tbody>
      </table>
    </div>
    
    <!-- Pagination -->
    <div class="flex flex-col sm:flex-row items-center justify-between mt-6 space-y-3 sm:space-y-0" id="vendor-pagination">
      <?php if ($total > 0): ?>
        <div class="text-sm text-gray-500 dark:text-gray-400">
          Showing <span class="font-medium"><?= ($page - 1) * $perPage + 1 ?></span> to 
          <span class="font-medium"><?= min($page * $perPage, $total) ?></span> of 
          <span class="font-medium"><?= $total ?></span> entries
        </div>
        <div class="flex space-x-2">
          <!-- Previous button -->
          <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" 
             class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 <?= $page === 1 ? 'opacity-50 cursor-not-allowed' : '' ?>" 
             <?= $page === 1 ? 'onclick="return false;"' : '' ?>>
            Previous
          </a>
          
          <!-- Page numbers -->
          <?php for ($i = 1; $i <= ceil($total / $perPage); $i++): ?>
            <a href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>" 
               class="px-3 py-1 <?= $page === $i ? 'bg-primary-500 text-white' : 'border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700' ?> rounded-md text-sm font-medium">
              <?= $i ?>
            </a>
          <?php endfor; ?>
          
          <!-- Next button -->
          <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" 
             class="px-3 py-1 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 <?= $page >= ceil($total / $perPage) ? 'opacity-50 cursor-not-allowed' : '' ?>" 
             <?= $page >= ceil($total / $perPage) ? 'onclick="return false;"' : '' ?>>
            Next
          </a>
        </div>
      <?php endif; ?>
    </div>
  </div>
</main>

<!-- Vendor View Modal -->
<?php if (isset($_GET['action']) && $_GET['action'] === 'view' && isset($_GET['id'])): 
  $vendorId = intval($_GET['id']);
  $stmt = mysqli_prepare($conn, "SELECT * FROM vendors WHERE id = ?");
  mysqli_stmt_bind_param($stmt, "i", $vendorId);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  $vendor = mysqli_fetch_assoc($result);
  
  if ($vendor): ?>
    <div id="vendor-view-modal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50">
      <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg w-full max-w-4xl max-h-[90vh] overflow-y-auto">
        <div class="p-6">
          <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-semibold dark:text-white">Vendor Details</h3>
            <a href="?" class="text-gray-400 hover:text-gray-500 dark:hover:text-gray-300">
              <i class="fas fa-times"></i>
            </a>
          </div>
          <div id="vendor-details-content" class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <h4 class="text-lg font-medium dark:text-white mb-2">Business Information</h4>
              <div class="space-y-3">
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Business Name</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['business_name']) ?></p>
                </div>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Business Type</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['business_type']) ?></p>
                </div>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Address</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['address']) ?></p>
                </div>
              </div>
            </div>
            <div>
              <h4 class="text-lg font-medium dark:text-white mb-2">Contact Information</h4>
              <div class="space-y-3">
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Email</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['email']) ?></p>
                </div>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Phone</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['phone']) ?></p>
                </div>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Contact Person</p>
                  <p class="dark:text-white"><?= htmlspecialchars($vendor['contact_person']) ?></p>
                </div>
              </div>
              <h4 class="text-lg font-medium dark:text-white mt-6 mb-2">Status</h4>
              <div class="space-y-3">
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Verification</p>
                  <p class="dark:text-white"><?= $vendor['is_verified'] == '1' ? 'Verified' : 'Not Verified' ?></p>
                </div>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Approval Status</p>
                  <p class="dark:text-white">
                    <?php 
                    switch($vendor['is_approved']) {
                      case '1': echo 'Approved'; break;
                      case '0': echo 'Pending'; break;
                      case '-1': echo 'Disapproved'; break;
                      default: echo 'Unknown';
                    }
                    ?>
                  </p>
                </div>
                <?php if ($vendor['approval_date']): ?>
                <div>
                  <p class="text-sm text-gray-500 dark:text-gray-400">Approval Date</p>
                  <p class="dark:text-white"><?= date('M j, Y g:i A', strtotime($vendor['approval_date'])) ?></p>
                </div>
                <?php endif; ?>
                <?php if ($vendor['approved_by']): 
                  $stmt = mysqli_prepare($conn, "SELECT full_name FROM admins WHERE id = ?");
                  mysqli_stmt_bind_param($stmt, "i", $vendor['approved_by']);
                  mysqli_stmt_execute($stmt);
                  $result = mysqli_stmt_get_result($stmt);
                  $admin = mysqli_fetch_assoc($result);
                  ?>
                  <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Approved By</p>
                    <p class="dark:text-white"><?= htmlspecialchars($admin['full_name'] ?? 'Unknown') ?></p>
                  </div>
                <?php endif; ?>
              </div>
              <div class="mt-6 flex space-x-3">
                <?php if ($vendor['is_approved'] != '1'): ?>
                  <a href="?action=approve&id=<?= $vendor['id'] ?>" class="px-4 py-2 bg-green-500 text-white rounded-md hover:bg-green-600">
                    Approve Vendor
                  </a>
                <?php endif; ?>
                <?php if ($vendor['is_approved'] != '-1'): ?>
                  <a href="?action=disapprove&id=<?= $vendor['id'] ?>" class="px-4 py-2 bg-yellow-500 text-white rounded-md hover:bg-yellow-600">
                    Disapprove Vendor
                  </a>
                <?php endif; ?>
                <?php if ($vendor['is_approved'] == '1' || $vendor['is_approved'] == '-1'): ?>
                  <a href="?action=reset&id=<?= $vendor['id'] ?>" class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">
                    Reset to Pending
                  </a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
<?php endif; ?>

<!-- Confirmation Modal -->
<div id="confirmation-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
  <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg w-full max-w-md">
    <div class="p-6">
      <div class="flex justify-between items-center mb-4">
        <h3 class="text-xl font-semibold dark:text-white" id="confirmation-title">Confirm Action</h3>
        <button onclick="closeModal('confirmation-modal')" class="text-gray-400 hover:text-gray-500 dark:hover:text-gray-300">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <p class="text-gray-600 dark:text-gray-300 mb-6" id="confirmation-message">Are you sure you want to perform this action?</p>
      <div class="flex justify-end space-x-3">
        <button onclick="closeModal('confirmation-modal')" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
          Cancel
        </button>
        <a href="#" id="confirm-action-btn" class="px-4 py-2 bg-red-500 text-white rounded-md text-sm font-medium hover:bg-red-600">
          Confirm
        </a>
      </div>
    </div>
  </div>
</div>

<?php
ob_start();
// Handle form submissions
if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'approve':
            if (isset($_GET['id'])) {
                $vendorId = intval($_GET['id']);
                $adminId = $_SESSION['admin_id'] ?? 1; // Replace with actual admin ID from session
                
                $stmt = mysqli_prepare($conn, "UPDATE vendors 
                                       SET is_approved = 1, approved_by = ?, approval_date = NOW() 
                                       WHERE id = ?");
                mysqli_stmt_bind_param($stmt, "ii", $adminId, $vendorId);
                if (mysqli_stmt_execute($stmt)) {
                    $_SESSION['message'] = 'Vendor approved successfully';
                } else {
                    $_SESSION['error'] = 'Failed to approve vendor';
                }
                header("Location: ?" . http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])));
                exit;
            }
            break;
            
        case 'disapprove':
            if (isset($_GET['id'])) {
                $vendorId = intval($_GET['id']);
                $adminId = $_SESSION['admin_id'] ?? 1; // Replace with actual admin ID from session
                
                $stmt = mysqli_prepare($conn, "UPDATE vendors 
                                       SET is_approved = -1, approved_by = ?, approval_date = NOW() 
                                       WHERE id = ?");
                mysqli_stmt_bind_param($stmt, "ii", $adminId, $vendorId);
                if (mysqli_stmt_execute($stmt)) {
                    $_SESSION['message'] = 'Vendor disapproved successfully';
                } else {
                    $_SESSION['error'] = 'Failed to disapprove vendor';
                }
                header("Location: ?" . http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])));
                exit;
            }
            break;
            
        case 'reset':
            if (isset($_GET['id'])) {
                $vendorId = intval($_GET['id']);
                $adminId = $_SESSION['admin_id'] ?? 1; // Replace with actual admin ID from session
                
                $stmt = mysqli_prepare($conn, "UPDATE vendors 
                                       SET is_approved = 0, approved_by = NULL, approval_date = NULL 
                                       WHERE id = ?");
                mysqli_stmt_bind_param($stmt, "i", $vendorId);
                if (mysqli_stmt_execute($stmt)) {
                    $_SESSION['message'] = 'Vendor status reset to pending successfully';
                } else {
                    $_SESSION['error'] = 'Failed to reset vendor status';
                }
                header("Location: ?" . http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])));
                exit;
            }
            break;
            
        case 'delete':
            if (isset($_GET['id'])) {
                $vendorId = intval($_GET['id']);
                
                $stmt = mysqli_prepare($conn, "DELETE FROM vendors WHERE id = ?");
                mysqli_stmt_bind_param($stmt, "i", $vendorId);
                if (mysqli_stmt_execute($stmt)) {
                    $_SESSION['message'] = 'Vendor deleted successfully';
                } else {
                    $_SESSION['error'] = 'Failed to delete vendor';
                }
                header("Location: ?" . http_build_query(array_diff_key($_GET, ['action' => '', 'id' => ''])));
                exit;
            }
            break;
    }
}

// Display messages
if (isset($_SESSION['message'])): ?>
  <div class="fixed top-4 right-4 z-50">
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
      <span class="block sm:inline"><?= $_SESSION['message'] ?></span>
      <span class="absolute top-0 bottom-0 right-0 px-4 py-3" onclick="this.parentElement.style.display='none'">
        <svg class="fill-current h-6 w-6 text-green-500" role="button" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><title>Close</title><path d="M14.348 14.849a1.2 1.2 0 0 1-1.697 0L10 11.819l-2.651 3.029a1.2 1.2 0 1 1-1.697-1.697l2.758-3.15-2.759-3.152a1.2 1.2 0 1 1 1.697-1.697L10 8.183l2.651-3.031a1.2 1.2 0 1 1 1.697 1.697l-2.758 3.152 2.758 3.15a1.2 1.2 0 0 1 0 1.698z"/></svg>
      </span>
    </div>
  </div>
  <?php unset($_SESSION['message']); ?>
<?php endif; ?>

<?php if (isset($_SESSION['error'])): ?>
  <div class="fixed top-4 right-4 z-50">
    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
      <span class="block sm:inline"><?= $_SESSION['error'] ?></span>
      <span class="absolute top-0 bottom-0 right-0 px-4 py-3" onclick="this.parentElement.style.display='none'">
        <svg class="fill-current h-6 w-6 text-red-500" role="button" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><title>Close</title><path d="M14.348 14.849a1.2 1.2 0 0 1-1.697 0L10 11.819l-2.651 3.029a1.2 1.2 0 1 1-1.697-1.697l2.758-3.15-2.759-3.152a1.2 1.2 0 1 1 1.697-1.697L10 8.183l2.651-3.031a1.2 1.2 0 1 1 1.697 1.697l-2.758 3.152 2.758 3.15a1.2 1.2 0 0 1 0 1.698z"/></svg>
      </span>
    </div>
  </div>
  <?php unset($_SESSION['error']); ?>
<?php endif; ob_end_flush(); ?>

<script>
// Modal functions
function openModal(modalId) {
  document.getElementById(modalId).classList.remove('hidden');
}

function closeModal(modalId) {
  document.getElementById(modalId).classList.add('hidden');
}

// Show confirmation dialog
function showConfirmation(title, message, actionUrl) {
  document.getElementById('confirmation-title').textContent = title;
  document.getElementById('confirmation-message').textContent = message;
  document.getElementById('confirm-action-btn').href = actionUrl;
  openModal('confirmation-modal');
}

// Confirm before disapproving
function confirmDisapprove(vendorId) {
  showConfirmation(
    "Disapprove Vendor", 
    "Are you sure you want to disapprove this vendor? They will no longer be able to access their account.",
    "?action=disapprove&id=" + vendorId
  );
  return false;
}

// Confirm before resetting
function confirmReset(vendorId) {
  showConfirmation(
    "Reset Vendor Status", 
    "Are you sure you want to reset this vendor's status to pending?",
    "?action=reset&id=" + vendorId
  );
  return false;
}
</script>

<?php include 'include/footer.php'; ?>