<?php
include 'include/header.php';
require_once '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$student_id = $_SESSION['user_id'];

// Get the user's bank account (if any)
$account_stmt = $conn->prepare("
    SELECT * FROM student_bank_accounts
    WHERE student_id = ?
    LIMIT 1
");
$account_stmt->bind_param("i", $student_id);
$account_stmt->execute();
$account_result = $account_stmt->get_result();
$bank_account = $account_result->fetch_assoc();

// Comprehensive list of Nigerian banks
$supported_banks = [
    ['code' => '033', 'name' => 'United Bank for Africa (UBA)'],
    ['code' => '063', 'name' => 'Access Bank'],
    ['code' => '023', 'name' => 'Citibank Nigeria'],
    ['code' => '215', 'name' => 'Unity Bank'],
    ['code' => '050', 'name' => 'Ecobank Nigeria'],
    ['code' => '070', 'name' => 'Fidelity Bank'],
    ['code' => '011', 'name' => 'First Bank of Nigeria'],
    ['code' => '214', 'name' => 'First City Monument Bank (FCMB)'],
    ['code' => '058', 'name' => 'Guaranty Trust Bank (GTBank)'],
    ['code' => '030', 'name' => 'Heritage Bank'],
    ['code' => '301', 'name' => 'Jaiz Bank'],
    ['code' => '082', 'name' => 'Keystone Bank'],
    ['code' => '076', 'name' => 'Polaris Bank'],
    ['code' => '101', 'name' => 'Providus Bank'],
    ['code' => '221', 'name' => 'Stanbic IBTC Bank'],
    ['code' => '232', 'name' => 'Sterling Bank'],
    ['code' => '100', 'name' => 'Suntrust Bank'],
    ['code' => '032', 'name' => 'Union Bank of Nigeria'],
    ['code' => '215', 'name' => 'Wema Bank'],
    ['code' => '035', 'name' => 'Zenith Bank'],
    ['code' => '999', 'name' => 'PalPay'],
    ['code' => '998', 'name' => 'OPay'],
];

// Sort banks alphabetically
usort($supported_banks, function($a, $b) {
    return strcmp($a['name'], $b['name']);
});
?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6" style="margin-bottom:80px">
    <div class="lg:col-span-2">
        <div class=" p-6   border ">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-bold">Bank Account</h2>
                <?php if (!$bank_account): ?>
                <button onclick="document.getElementById('addAccountModal').classList.remove('hidden')"
                        class="bg-primary-500 hover:bg-primary-600 text-white px-4 py-2 text-sm font-medium">
                    <i class="fas fa-plus mr-1"></i> Add Account
                </button>
                <?php endif; ?>
            </div>
            
            <?php if (!$bank_account): ?>
                <div class="text-center py-12 text-gray-500">
                    <i class="fas fa-university text-4xl mb-4"></i>
                    <p class="text-lg">No bank account linked</p>
                    <p class="text-sm mt-2">Add your bank account to withdraw funds</p>
                </div>
            <?php else: ?>
                <div class="space-y-4">
                    <div class="flex items-center p-4 bg-gray-50 hover:bg-gray-100 rounded-lg transition">
                        <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mr-4">
                            <i class="fas fa-university text-blue-500 text-xl"></i>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-medium"><?= htmlspecialchars($bank_account['bank_name']) ?></h3>
                            <p class="text-sm text-gray-500">
                                <?= htmlspecialchars($bank_account['account_name']) ?> • <?= htmlspecialchars($bank_account['account_number']) ?>
                            </p>
                        </div>
                        <div class="flex space-x-2">
                            <span class="text-sm font-medium text-primary-500">Primary</span>
                            
                            <form method="POST" action="process_bank_account.php" 
                                  onsubmit="return confirm('Are you sure you want to delete this account?');">
                                <input type="hidden" name="account_id" value="<?= $bank_account['id'] ?>">
                                <button type="submit" name="delete_account" 
                                        class="text-red-500 hover:text-red-600 text-sm font-medium ml-2">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="lg:col-span-1">
        <div class="p-6 ">
            <h3 class="text-lg font-semibold mb-4">Bank Transfer Information</h3>
            <div class="space-y-4">
                <div class="p-4 bg-yellow-50 border-l-4 border-yellow-400">
                    <p class="text-sm text-yellow-700">
                        <i class="fas fa-info-circle mr-1"></i> Withdrawals may take 1-3 business days to process.
                    </p>
                </div>
                
                <div class="p-4 bg-red-50 border-l-4 border-red-400">
                    <p class="text-sm text-red-700">
                        <i class="fas fa-exclamation-triangle mr-1"></i> <strong>IMPORTANT:</strong> Ensure all bank details are correct. Incorrect details may result in failed transfers.
                    </p>
                </div>
                
                <div class="p-4 bg-blue-50 border-l-4 border-blue-400">
                    <p class="text-sm text-blue-700">
                        <i class="fas fa-info-circle mr-1"></i> You can only have one bank account.
                    </p>
                </div>
                
                <div class="p-4 bg-green-50 border-l-4 border-green-400">
                    <p class="text-sm text-green-700">
                        <i class="fas fa-info-circle mr-1"></i> Ensure your account name matches your registered name.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Bank Account Modal -->
<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden" id="addAccountModal">
    <div class="bg-white p-6 rounded-lg w-full max-w-md relative">
        <span class="absolute top-4 right-4 text-gray-500 cursor-pointer text-2xl" 
              onclick="document.getElementById('addAccountModal').classList.add('hidden')">&times;</span>
        
        <h3 class="text-xl font-bold mb-4">Add Bank Account</h3>
        
        <div class="p-4 bg-red-50 border-l-4 border-red-400 mb-4 rounded">
            <p class="text-sm text-red-700">
                <i class="fas fa-exclamation-triangle mr-1"></i> <strong>WARNING:</strong> Please double-check your bank details. Transfers to incorrect accounts cannot be reversed.
            </p>
        </div>
        
        <form id="addAccountForm" method="POST" action="process_bank_account.php" onsubmit="return confirm('Are you sure the bank details you entered are correct?');">
            <input type="hidden" name="student_id" value="<?= $student_id ?>">
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Bank</label>
                <select name="bank_code" id="bankCode" class="w-full px-3 py-2 border rounded-lg" required>
                    <option value="">Select Bank</option>
                    <?php foreach ($supported_banks as $bank): ?>
                        <option value="<?= $bank['code'] ?>"><?= $bank['name'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Account Number</label>
                <input type="text" name="account_number" id="accountNumber" 
                       class="w-full px-3 py-2 border rounded-lg" required maxlength="10">
                <p class="text-xs text-gray-500 mt-1">10-digit account number</p>
            </div>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Account Name</label>
                <input type="text" name="account_name" id="accountNameInput" 
                       class="w-full px-3 py-2 border rounded-lg" required>
                <p class="text-xs text-gray-500 mt-1">Must exactly match the name on your bank account</p>
            </div>
            
            <div class="flex justify-end space-x-3">
                <button type="button" 
                        onclick="document.getElementById('addAccountModal').classList.add('hidden')"
                        class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                    Cancel
                </button>
                <button type="submit" name="add_account" id="submitBtn"
                        class="px-4 py-2 bg-primary-500 text-white rounded-lg hover:bg-primary-600">
                    Save Account
                </button>
            </div>
        </form>
    </div>
</div>

<?php include 'include/footer.php'; ?>