<!-- Top Bar -->
<header class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-200 p-4 flex justify-between items-center sticky top-0 z-30">
  <button class="sidebar-toggle p-2 lg:hidden">
    <i class="fas fa-bars text-gray-600 dark:text-gray-300 text-xl"></i>
  </button>
  <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-200">Dashboard</h2>
  <div class="flex items-center space-x-4 relative">
    <button id="theme-toggle" class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700">
      <i class="fas fa-moon text-gray-500 dark:text-primary-300" id="theme-icon"></i>
    </button>
    <button class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700">
      <i class="fas fa-bell text-gray-500 dark:text-gray-300"></i>
    </button>
    <button id="profile-toggle" class="w-8 h-8 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center">
      <i class="fas fa-user text-primary-500 dark:text-primary-600"></i>
    </button>
    <div id="profile-dropdown" class="profile-dropdown dark:text-white">
      <div class="p-4 border-b border-gray-100 dark:border-gray-600">
        <p class="font-medium"><?php echo htmlspecialchars($_SESSION['full_name']); ?></p>
        <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo htmlspecialchars($_SESSION['email']); ?></p>
      </div>
      <a href="profile.php" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm">Profile</a>
      <a href="settings.php" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm">Settings</a>
      <a href="../logout.php" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-gray-700 text-sm border-t border-gray-100 dark:border-gray-600">Logout</a>
    </div>
  </div>
</header>

<script>
// Profile dropdown toggle
document.getElementById('profile-toggle').addEventListener('click', function() {
    document.getElementById('profile-dropdown').classList.toggle('active');
});

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const dropdown = document.getElementById('profile-dropdown');
    const profileBtn = document.getElementById('profile-toggle');
    
    if (!profileBtn.contains(event.target) {
        dropdown.classList.remove('active');
    }
});
</script>