<?php include 'include/header.php'; ?>

<!-- Combined Layout -->

<!-- Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50 dark:bg-gray-900 overflow-y-auto">
  <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Balance Card -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 lg:col-span-1">
      <div class="flex justify-between items-start">
        <div>
          <p class="text-gray-500 dark:text-gray-400 text-sm">Available Balance</p>
          <p class="text-3xl font-bold text-primary-600 dark:text-primary-400 mt-1">$1,245.00</p>
        </div>
        <div class="w-12 h-12 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center">
          <i class="fas fa-wallet text-primary-500 dark:text-primary-600 text-xl"></i>
        </div>
      </div>
      <div class="flex space-x-3 mt-6">
        <a href="wallet.php">
        <button class="flex-1 bg-primary-500 dark:bg-primary-600 text-white px-4 py-2 rounded-lg text-sm font-medium">
          <i class="fas fa-plus mr-1"></i> Add Funds
        </button>
      </a>
        <button class="flex-1 bg-white dark:bg-gray-700 text-primary-500 dark:text-primary-400 border border-primary-500 dark:border-primary-400 px-4 py-2 rounded-lg text-sm font-medium">
          <i class="fas fa-history mr-1"></i> History
        </button>
      </div>
    </div>

    <!-- Quick Stats -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 lg:col-span-2">
      <h3 class="text-lg font-semibold mb-4 dark:text-white">Quick Actions</h3>
      <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <button class="bg-primary-50 dark:bg-gray-700 p-4 rounded-xl flex flex-col items-center hover:bg-primary-100 dark:hover:bg-gray-600 transition">
          <div class="w-12 h-12 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center mb-2">
            <i class="fas fa-utensils text-primary-500 dark:text-primary-600 text-xl"></i>
          </div>
          <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Cafeteria</span>
        </button>
        <button class="bg-primary-50 dark:bg-gray-700 p-4 rounded-xl flex flex-col items-center hover:bg-primary-100 dark:hover:bg-gray-600 transition">
          <div class="w-12 h-12 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center mb-2">
            <i class="fas fa-book text-primary-500 dark:text-primary-600 text-xl"></i>
          </div>
          <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Bookstore</span>
        </button>
        <button class="bg-primary-50 dark:bg-gray-700 p-4 rounded-xl flex flex-col items-center hover:bg-primary-100 dark:hover:bg-gray-600 transition">
          <div class="w-12 h-12 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center mb-2">
            <i class="fas fa-t-shirt text-primary-500 dark:text-primary-600 text-xl"></i>
          </div>
          <span class="text-sm font-medium text-gray-700 dark:text-gray-200">Merchandise</span>
        </button>
        <button class="bg-primary-50 dark:bg-gray-700 p-4 rounded-xl flex flex-col items-center hover:bg-primary-100 dark:hover:bg-gray-600 transition">
          <div class="w-12 h-12 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center mb-2">
            <i class="fas fa-ellipsis-h text-primary-500 dark:text-primary-600 text-xl"></i>
          </div>
          <span class="text-sm font-medium text-gray-700 dark:text-gray-200">More</span>
        </button>
      </div>
    </div>

    <!-- Recent Transactions -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm p-6 border border-gray-100 dark:border-gray-700 lg:col-span-3">
      <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold dark:text-white">Recent Transactions</h3>
        <button class="text-primary-500 dark:text-primary-400 text-sm font-medium">View All</button>
      </div>
      <div class="space-y-3">
        <div class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg transition">
          <div class="w-10 h-10 bg-primary-100 dark:bg-primary-200 rounded-full flex items-center justify-center mr-4">
            <i class="fas fa-utensils text-primary-500 dark:text-primary-600"></i>
          </div>
          <div class="flex-1">
            <p class="font-medium dark:text-white">Cafeteria Payment</p>
            <p class="text-xs text-gray-500 dark:text-gray-400">Today, 12:30 PM</p>
          </div>
          <p class="font-medium text-red-500">-$8.50</p>
        </div>
        <div class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg transition">
          <div class="w-10 h-10 bg-green-100 dark:bg-green-200 rounded-full flex items-center justify-center mr-4">
            <i class="fas fa-wallet text-green-500 dark:text-green-600"></i>
          </div>
          <div class="flex-1">
            <p class="font-medium dark:text-white">Wallet Top-up</p>
            <p class="text-xs text-gray-500 dark:text-gray-400">Yesterday, 4:15 PM</p>
          </div>
          <p class="font-medium text-green-500">+$100.00</p>
        </div>
        <div class="flex items-center p-4 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-lg transition">
          <div class="w-10 h-10 bg-blue-100 dark:bg-blue-200 rounded-full flex items-center justify-center mr-4">
            <i class="fas fa-book text-blue-500 dark:text-blue-600"></i>
          </div>
          <div class="flex-1">
            <p class="font-medium dark:text-white">Bookstore Purchase</p>
            <p class="text-xs text-gray-500 dark:text-gray-400">May 25, 10:00 AM</p>
          </div>
          <p class="font-medium text-red-500">-$45.25</p>
        </div>
      </div>
    </div>
  </div>
</main>


<?php include 'include/footer.php'; ?>