<?php
// register.php
require '../config/conn.php';
require '../config/session.php';

// Initialize error messages
$errors = [
    'full_name' => '',
    'email' => '',
    'phone' => '',
    'gender' => '',
    'password' => '',
    'confirm_password' => '',
    'terms' => ''
];

// Retrieve form data from session if available
$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
$full_name = $form_data['full_name'] ?? '';
$email = $form_data['email'] ?? '';
$phone = $form_data['phone'] ?? '';
$gender = $form_data['gender'] ?? '';

// If there are validation errors from form submission, display them
if (isset($_SESSION['validation_errors'])) {
    $errors = array_merge($errors, $_SESSION['validation_errors']);
    unset($_SESSION['validation_errors']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Portal - Registration</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="../src/output.css" rel="stylesheet">
      <script src="https://cdn.tailwindcss.com"></script>
    <style>
        :root {
            --primary: #FBBB01;
            --primary-dark: #e0a800;
            --primary-light: #ffd54f;
            --text-primary: #1a202c;
            --text-secondary: #4a5568;
            --card-bg: #ffffff;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --error-color: #e53e3e;
            --success-color: #48bb78;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            transition: background-color 0.3s, color 0.3s, transform 0.3s;
        }

        body {
            font-family: 'Poppins', 'Helvetica', sans-serif;
            background-color: #ffffff;
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .error-text {
            color: var(--error-color);
            font-size: 0.8rem;
            margin-top: 5px;
            display: block;
        }

        .success-message {
            background-color: rgba(72, 187, 120, 0.1);
            color: #48bb78;
            border-left: 3px solid #48bb78;
            padding: 10px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .error-message {
            background-color: rgba(229, 62, 62, 0.1);
            color: #e53e3e;
            border-left: 3px solid #e53e3e;
            padding: 10px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes button-loading-spinner {
            from { transform: rotate(0turn); }
            to { transform: rotate(1turn); }
        }
        
        .school-logo {
            max-height: 80px;
            margin-bottom: 20px;
        }

        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: button-loading-spinner 1s ease infinite;
            margin-right: 10px;
            vertical-align: middle;
        }

        .btn-loading .btn-text {
            opacity: 0.7;
        }
    </style>
</head>
<body>
    <div class="auth-container max-w-[1200px] w-full flex flex-col items-center">
        <div class="auth-header text-center mb-[30px]">
            <!-- School Logo -->
            <img src="path/to/your/school-logo.png" alt="School Logo" class="school-logo">
            <h1 class="text-[2.5rem] mb-[10px] bg-gradient-to-r from-[#FBBB01] to-[#ffd54f] bg-clip-text text-transparent">Student Portal</h1>
            <p class="text-[#4a5568] text-[1.1rem]">Create your account to access academic resources</p>
        </div>

        <!-- Messages container for AJAX responses -->
        <div id="messageContainer" class="w-full max-w-[500px] mb-[20px]"></div>

        <!-- Display session messages -->
        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="form-message success-message w-full max-w-[500px] mb-[20px]" style="display: block;">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="form-message error-message w-full max-w-[500px] mb-[20px]" style="display: block;">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        ?>

        <form id="registerForm" class="auth-form active w-full max-w-[500px] bg-white rounded-[10px] p-[30px] shadow-[0_4px_6px_rgba(0,0,0,0.1)] border border-gray-200" method="POST">
            <div class="form-group mb-[20px]">
                <label for="registerName" class="block mb-[8px] font-[500] text-[#1a202c]">Full Name</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-user absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="text" id="registerName" name="full_name" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your full name" required value="<?php echo htmlspecialchars($full_name); ?>">
                </div>
                <small class="error-text" id="full_name_error"><?php echo $errors['full_name']; ?></small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerEmail" class="block mb-[8px] font-[500] text-[#1a202c]">Email Address</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-envelope absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="email" id="registerEmail" name="email" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your email" required value="<?php echo htmlspecialchars($email); ?>">
                </div>
                <small class="error-text" id="email_error"><?php echo $errors['email']; ?></small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerPhone" class="block mb-[8px] font-[500] text-[#1a202c]">Phone Number</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-phone absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="tel" id="registerPhone" name="phone" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your phone number" required value="<?php echo htmlspecialchars($phone); ?>">
                </div>
                <small class="error-text" id="phone_error"><?php echo $errors['phone']; ?></small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerGender" class="block mb-[8px] font-[500] text-[#1a202c]">Gender</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-venus-mars absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <select id="registerGender" name="gender" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" required>
                        <option value="">Select Gender</option>
                        <option value="male" <?php echo ($gender === 'male') ? 'selected' : ''; ?>>Male</option>
                        <option value="female" <?php echo ($gender === 'female') ? 'selected' : ''; ?>>Female</option>
                        <option value="other" <?php echo ($gender === 'other') ? 'selected' : ''; ?>>Other</option>
                        <option value="prefer-not-to-say" <?php echo ($gender === 'prefer-not-to-say') ? 'selected' : ''; ?>>Prefer not to say</option>
                    </select>
                </div>
                <small class="error-text" id="gender_error"><?php echo $errors['gender']; ?></small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerPassword" class="block mb-[8px] font-[500] text-[#1a202c]">Password</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-lock absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="password" id="registerPassword" name="password" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Create a password" required>
                    <i class="fas fa-eye password-toggle absolute right-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568] cursor-pointer" id="toggleRegisterPassword"></i>
                </div>
                <small class="error-text" id="password_error"><?php echo $errors['password']; ?></small>
                <small class="text-[#4a5568] block mt-[5px]">
                    Must be at least 8 characters with one uppercase, one lowercase, one number, and one special character
                </small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerConfirmPassword" class="block mb-[8px] font-[500] text-[#1a202c]">Confirm Password</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-lock absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="password" id="registerConfirmPassword" name="confirm_password" 
                           class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" placeholder="Confirm your password" required>
                    <i class="fas fa-eye password-toggle absolute right-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568] cursor-pointer" id="toggleConfirmPassword"></i>
                </div>
                <small class="error-text" id="confirm_password_error"><?php echo $errors['confirm_password']; ?></small>
            </div>
            
            <div class="form-group mb-[20px]">
                <input type="checkbox" id="acceptTerms" name="accept_terms" required class="mr-[8px]">
                <label for="acceptTerms" class="text-[#1a202c]">I agree to the <a href="terms.php" class="text-[#FBBB01] hover:underline">Terms of Service</a> and <a href="privacy.php" class="text-[#FBBB01] hover:underline">Privacy Policy</a></label>
                <small class="error-text" id="terms_error"><?php echo $errors['terms']; ?></small>
            </div>
            
            <button type="submit" class="btn w-full py-[12px] bg-[#FBBB01] text-white border-none rounded-[8px] font-['Poppins'] text-[1rem] font-[500] cursor-pointer hover:bg-[#e0a800] mt-[20px] relative transition-colors duration-300" id="submitBtn" name="register">
                <span class="btn-text">Create Account</span>
                <span class="loading-spinner" style="display: none;"></span>
            </button>
            
            <div class="auth-switch text-center text-[#4a5568] mt-[20px]">
                Already have an account? <a href="login.php" class="text-[#FBBB01] no-underline ml-[5px] hover:underline">Sign in</a>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Password Toggle Visibility
            function setupPasswordToggle(toggleId, inputId) {
                const toggle = document.getElementById(toggleId);
                const input = document.getElementById(inputId);
                
                toggle.addEventListener('click', function() {
                    if (input.type === 'password') {
                        input.type = 'text';
                        toggle.classList.remove('fa-eye');
                        toggle.classList.add('fa-eye-slash');
                    } else {
                        input.type = 'password';
                        toggle.classList.remove('fa-eye-slash');
                        toggle.classList.add('fa-eye');
                    }
                });
            }
            
            setupPasswordToggle('toggleRegisterPassword', 'registerPassword');
            setupPasswordToggle('toggleConfirmPassword', 'registerConfirmPassword');
            
            // AJAX Form Submission
            const registerForm = document.getElementById('registerForm');
            const submitBtn = document.getElementById('submitBtn');
            const btnText = submitBtn.querySelector('.btn-text');
            const loadingSpinner = submitBtn.querySelector('.loading-spinner');
            const messageContainer = document.getElementById('messageContainer');
            
            registerForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Show loading state
                submitBtn.disabled = true;
                btnText.textContent = 'Creating Account...';
                loadingSpinner.style.display = 'inline-block';
                submitBtn.classList.add('btn-loading');
                
                // Clear previous messages
                messageContainer.innerHTML = '';
                clearErrorMessages();
                
                // Get form data
                const formData = new FormData(registerForm);
                
                // Send AJAX request
                fetch('process_register.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    // Reset button state
                    submitBtn.disabled = false;
                    btnText.textContent = 'Create Account';
                    loadingSpinner.style.display = 'none';
                    submitBtn.classList.remove('btn-loading');
                    
                    if (data.success) {
                        // Show success message
                        showMessage(data.message, 'success');
                        
                        // Clear form if registration was successful
                        registerForm.reset();
                        
                        // Redirect to login page after 3 seconds
                        setTimeout(() => {
                            window.location.href = 'login.php';
                        }, 3000);
                    } else {
                        // Show error messages
                        if (data.message) {
                            showMessage(data.message, 'error');
                        }
                        
                        // Show field-specific errors
                        if (data.errors) {
                            displayFieldErrors(data.errors);
                        }
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    
                    // Reset button state
                    submitBtn.disabled = false;
                    btnText.textContent = 'Create Account';
                    loadingSpinner.style.display = 'none';
                    submitBtn.classList.remove('btn-loading');
                    
                    showMessage('An error occurred. Please try again.', 'error');
                });
            });
            
            function showMessage(message, type) {
                const messageDiv = document.createElement('div');
                messageDiv.className = type === 'success' ? 'success-message' : 'error-message';
                messageDiv.textContent = message;
                messageContainer.appendChild(messageDiv);
                
                // Auto-hide success messages after 5 seconds
                if (type === 'success') {
                    setTimeout(() => {
                        messageDiv.style.display = 'none';
                    }, 5000);
                }
            }
            
            function clearErrorMessages() {
                const errorElements = document.querySelectorAll('.error-text');
                errorElements.forEach(element => {
                    element.textContent = '';
                });
            }
            
            function displayFieldErrors(errors) {
                for (const field in errors) {
                    const errorElement = document.getElementById(field + '_error');
                    if (errorElement) {
                        errorElement.textContent = errors[field];
                    }
                }
            }
        });
    </script>
</body>
</html>
<?php
// Clear form data from session after displaying it
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>