<?php
require_once '../config/conn.php';
session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['id'])) {
    die('Unauthorized');
}

$transaction_id = intval($_GET['id']);
$student_id = $_SESSION['user_id'];

// Verify the transaction belongs to the student
$stmt = $conn->prepare("
    SELECT t.*, b.bank_name, b.account_number, b.account_name 
    FROM wallet_transactions t
    LEFT JOIN student_bank_accounts b ON t.bank_account_id = b.id
    JOIN student_wallets w ON t.wallet_id = w.id
    WHERE t.id = ? AND w.student_id = ?
");
$stmt->bind_param("ii", $transaction_id, $student_id);
$stmt->execute();
$result = $stmt->get_result();
$transaction = $result->fetch_assoc();

if (!$transaction) {
    die('Transaction not found');
}
?>

<div id="transaction-details-page" class="fixed inset-0 bg-white z-50 overflow-y-auto p-6">
    <div class="max-w-3xl mx-auto">
        <div class="flex justify-between items-center mb-6">
            <a href="#" id="back-to-transactions" class="text-primary-500 hover:text-primary-700 flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> Back to Transactions
            </a>
        </div>
        
        <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            <div class="space-y-4">
                <div class="flex justify-between items-center pb-4 border-b">
                    <h3 class="text-xl font-bold">Transaction Details</h3>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                        <?= $transaction['status'] === 'completed' ? 'bg-green-100 text-green-800' : 
                           ($transaction['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' : 
                           'bg-red-100 text-red-800') ?>">
                        <?= ucfirst($transaction['status']) ?>
                    </span>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-4">
                        <div>
                            <p class="text-sm text-gray-500">Transaction Type</p>
                            <p class="font-medium capitalize"><?= $transaction['transaction_type'] ?></p>
                        </div>
                        
                        <div>
                            <p class="text-sm text-gray-500">Amount</p>
                            <p class="font-medium <?= $transaction['transaction_type'] === 'credit' || $transaction['transaction_type'] === 'deposit' ? 'text-green-600' : 'text-red-600' ?>">
                                <?= ($transaction['transaction_type'] === 'credit' || $transaction['transaction_type'] === 'deposit') ? '+' : '-' ?>₦<?= number_format($transaction['amount'], 2) ?>
                            </p>
                        </div>
                        
                        <div>
                            <p class="text-sm text-gray-500">Date & Time</p>
                            <p><?= date('M j, Y g:i A', strtotime($transaction['created_at'])) ?></p>
                        </div>
                    </div>
                    
                    <div class="space-y-4">
                        <div>
                            <p class="text-sm text-gray-500">Description</p>
                            <p class="font-medium"><?= htmlspecialchars($transaction['description']) ?></p>
                        </div>
                        
                        <div>
                            <p class="text-sm text-gray-500">Reference</p>
                            <p class="font-mono"><?= htmlspecialchars($transaction['reference']) ?></p>
                        </div>
                        
                        <?php if ($transaction['gateway'] || $transaction['payment_gateway']): ?>
                            <div>
                                <p class="text-sm text-gray-500">Payment Method</p>
                                <p><?= htmlspecialchars($transaction['gateway'] ?: $transaction['payment_gateway']) ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php if ($transaction['bank_name']): ?>
                    <div class="pt-4 mt-4 border-t">
                        <h4 class="font-medium mb-3">Bank Details</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-500">Bank Name</p>
                                <p><?= htmlspecialchars($transaction['bank_name']) ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Account Name</p>
                                <p><?= htmlspecialchars($transaction['account_name']) ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Account Number</p>
                                <p>****<?= substr($transaction['account_number'], -4) ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                
                <?php if ($transaction['metadata']): ?>
                    <div class="pt-4 mt-4 border-t">
                        <h4 class="font-medium mb-3">Additional Information</h4>
                        <pre class="bg-gray-50 p-3 rounded text-sm overflow-x-auto"><?= json_encode(json_decode($transaction['metadata']), JSON_PRETTY_PRINT) ?></pre>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>