<?php 
include 'include/header.php';

// Verify session and get student data
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once '../config/conn.php';

// Get wallet data
$student_id = $_SESSION['user_id'];
$wallet_stmt = $conn->prepare("
    SELECT w.* FROM student_wallets w
    JOIN students s ON w.student_id = s.id
    WHERE s.id = ?
");
$wallet_stmt->bind_param("i", $student_id);
$wallet_stmt->execute();
$wallet_result = $wallet_stmt->get_result();
$wallet = $wallet_result->fetch_assoc();

if (!$wallet) {
    header("Location: wallet.php");
    exit();
}
?>

<!-- Main Content Area -->
<main class="main-content flex-1 p-6 bg-gray-50">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-1xl font-bold">Transaction History</h1>
        <a href="wallet.php" class="text-primary-500 hover:underline">
            <i class="fas fa-arrow-left mr-1"></i> Back to Wallet
        </a>
    </div>

    <div class=" p-6 ">
        <!-- Transactions will be loaded here -->
        <div id="transactions-container">
            <div class="text-center py-12">
                <div class="animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary-500 mx-auto mb-4"></div>
                <p>Loading transactions...</p>
            </div>
        </div>
    </div>
</main>

<!-- Loading Overlay -->
<div id="loading-overlay" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
    <div class="bg-white p-6 rounded-lg shadow-lg text-center">
        <div class="animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary-500 mx-auto mb-4"></div>
        <p>Loading...</p>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load initial transactions
    loadTransactions();
});

function loadTransactions(page = 1) {
    showLoading();
    fetch(`load_transactions.php?page=${page}`)
        .then(response => response.text())
        .then(html => {
            document.getElementById('transactions-container').innerHTML = html;
            hideLoading();
        })
        .catch(error => {
            document.getElementById('transactions-container').innerHTML = `
                <div class="text-center py-12 text-red-500">
                    <i class="fas fa-exclamation-circle text-4xl mb-4"></i>
                    <p>Failed to load transactions. Please try again.</p>
                </div>
            `;
            hideLoading();
        });
}

function showTransactionDetails(transactionId) {
    // Show loading overlay
    showLoading();
    
    // Load the transaction details page via AJAX
    fetch(`transaction_details.php?id=${transactionId}`)
        .then(response => response.text())
        .then(html => {
            // Create a new div for the details page
            const detailsPage = document.createElement('div');
            detailsPage.id = 'transaction-details-page';
            detailsPage.innerHTML = html;
            
            // Add to body
            document.body.appendChild(detailsPage);
            
            // Hide the transactions list
            document.querySelector('main').classList.add('hidden');
            
            // Add back button functionality
            document.getElementById('back-to-transactions').addEventListener('click', function(e) {
                e.preventDefault();
                hideTransactionDetails();
            });
            
            hideLoading();
        })
        .catch(error => {
            hideLoading();
            alert('Failed to load transaction details');
        });
}

function hideTransactionDetails() {
    // Remove the details page
    const detailsPage = document.getElementById('transaction-details-page');
    if (detailsPage) {
        detailsPage.remove();
    }
    
    // Show the transactions list
    document.querySelector('main').classList.remove('hidden');
}

function showLoading() {
    document.getElementById('loading-overlay').classList.remove('hidden');
}

function hideLoading() {
    document.getElementById('loading-overlay').classList.add('hidden');
}

// Handle pagination clicks
document.addEventListener('click', function(e) {
    if (e.target.matches('.pagination-link')) {
        e.preventDefault();
        const page = e.target.getAttribute('data-page');
        loadTransactions(page);
    }
});
</script>

<?php include 'include/footer.php'; ?>