<?php
require_once '../../config/conn.php';
header('Content-Type: application/json');

session_start();
if (!isset($_SESSION['vendor_id']) || empty($_SESSION['vendor_id'])) {
    echo json_encode(['error' => 'Session expired. Please login again.']);
    exit();
}

$vendor_id = $_SESSION['vendor_id'];
$account_id = $_GET['id'] ?? null;

try {
    if ($account_id) {
        // Get specific account
        $stmt = $conn->prepare("SELECT * FROM vendor_bank_accounts WHERE id = ? AND vendor_id = ?");
        $stmt->bind_param("ss", $account_id, $vendor_id);
    } else {
        // Get vendor's account
        $stmt = $conn->prepare("SELECT * FROM vendor_bank_accounts WHERE vendor_id = ? LIMIT 1");
        $stmt->bind_param("s", $vendor_id);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        echo json_encode($result->fetch_assoc());
    } else {
        echo json_encode(['error' => 'No bank account found']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>