<?php
include 'include/header.php';

// Verify vendor session
if (!isset($_SESSION['vendor_id']) || empty($_SESSION['vendor_id'])) {
    header("Location: vendor-login.php");
    exit();
}
$vendor_id = $_SESSION['vendor_id'];

// List of supported Nigerian banks
$supportedBanks = [
    'Access Bank', 'First Bank', 'GTBank', 
    'UBA', 'Zenith Bank', 'Fidelity Bank',
    'Union Bank', 'Stanbic IBTC', 'Ecobank'
];
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Bank Account</h1>
        <button onclick="window.location.href='add-bank-account.php'" class="bg-primary-500 text-white px-4 py-2 rounded-lg">
            <i class="fas fa-plus mr-1"></i> Add Account
        </button>
    </div>

    <div id="messageContainer" class="mb-4"></div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Bank</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Account Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Account Number</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200" id="bankAccountTable">
                <!-- Will be populated via AJAX -->
            </tbody>
        </table>
    </div>
</div>

<script>
// Load bank account on page load
document.addEventListener('DOMContentLoaded', function() {
    loadBankAccount();
});

// Load vendor's bank account
function loadBankAccount() {
    fetch('ajax/get_bank_account.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            const tableBody = document.getElementById('bankAccountTable');
            
            if (data.error) {
                tableBody.innerHTML = `
                    <tr>
                        <td colspan="4" class="px-6 py-4 text-center text-gray-500">${data.error}</td>
                    </tr>
                `;
            } else if (data.id) {
                tableBody.innerHTML = `
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">${data.bank_name}</td>
                        <td class="px-6 py-4 whitespace-nowrap">${data.account_name}</td>
                        <td class="px-6 py-4 whitespace-nowrap">••••${data.account_number.slice(-4)}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <a href="edit-bank-account.php?id=${data.id}" class="text-blue-500 hover:text-blue-700 mr-3">
                                <i class="fas fa-edit"></i>
                            </a>
                            <button onclick="deleteBankAccount('${data.id}')" class="text-red-500 hover:text-red-700">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            } else {
                tableBody.innerHTML = `
                    <tr>
                        <td colspan="4" class="px-6 py-4 text-center text-gray-500">No bank account found</td>
                    </tr>
                `;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('error', 'Failed to load bank account');
        });
}

// Delete bank account
function deleteBankAccount(accountId) {
    if (confirm('Are you sure you want to delete this bank account?')) {
        const formData = new FormData();
        formData.append('account_id', accountId);
        
        fetch('ajax/delete_bank_account.php', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showMessage('success', data.message);
                loadBankAccount();
            } else {
                showMessage('error', data.message || 'Failed to delete account');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('error', 'Failed to delete account');
        });
    }
}

// Show message
function showMessage(type, message) {
    const messageContainer = document.getElementById('messageContainer');
    const alertClass = type === 'success' ? 
        'bg-green-100 border-green-400 text-green-700' : 
        'bg-red-100 border-red-400 text-red-700';
    
    messageContainer.innerHTML = `
        <div class="border ${alertClass} px-4 py-3 rounded">
            ${message}
        </div>
    `;
    
    // Auto-hide after 5 seconds
    setTimeout(() => {
        messageContainer.innerHTML = '';
    }, 5000);
}
</script>

<?php include 'include/footer.php'; ?>