<!-- Bottom Navigation - Only shows on mobile -->
<nav class="bottom-nav bg-white dark:bg-gray-800 lg:hidden">
  <a href="#" class="bottom-nav-item text-gray-400">
    <i class="fas fa-home bottom-nav-icon"></i>
    <span class="bottom-nav-text">Home</span>
  </a>
  <a href="#" class="bottom-nav-item text-gray-400">
    <i class="fas fa-exchange-alt bottom-nav-icon"></i>
    <span class="bottom-nav-text">Transactions</span>
  </a>
  <a href="#" class="bottom-nav-item text-primary-500 dark:text-primary-400">
    <i class="fas fa-wallet bottom-nav-icon"></i>
    <span class="bottom-nav-text">Balance</span>
  </a>
  <a href="#" class="bottom-nav-item text-gray-400">
    <i class="fas fa-user bottom-nav-icon"></i>
    <span class="bottom-nav-text">Profile</span>
  </a>
</nav>

<script>
  // Mobile sidebar toggle functionality
  document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.querySelector('.sidebar');
    const sidebarToggle = document.querySelector('.sidebar-toggle');
    const sidebarClose = document.querySelector('.sidebar-close');
    
    if (sidebarToggle) {
      sidebarToggle.addEventListener('click', function() {
        sidebar.classList.add('active');
      });
    }
    
    if (sidebarClose) {
      sidebarClose.addEventListener('click', function() {
        sidebar.classList.remove('active');
      });
    }
    
    // Profile dropdown toggle
    const profileToggle = document.getElementById('profile-toggle');
    const profileDropdown = document.getElementById('profile-dropdown');
    
    if (profileToggle && profileDropdown) {
      profileToggle.addEventListener('click', function() {
        profileDropdown.classList.toggle('active');
      });
      
      // Close when clicking outside
      document.addEventListener('click', function(event) {
        if (!profileToggle.contains(event.target) && !profileDropdown.contains(event.target)) {
          profileDropdown.classList.remove('active');
        }
      });
    }

    // Dark/Light mode toggle
    const themeToggle = document.getElementById('theme-toggle');
    const themeIcon = document.getElementById('theme-icon');
    const html = document.documentElement;

    // Check for saved user preference or use system preference
    if (localStorage.getItem('theme') === 'dark' || (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
      html.classList.add('dark');
      if (themeIcon) themeIcon.classList.replace('fa-moon', 'fa-sun');
    }

    function toggleTheme() {
      if (html.classList.contains('dark')) {
        html.classList.remove('dark');
        localStorage.setItem('theme', 'light');
        if (themeIcon) themeIcon.classList.replace('fa-sun', 'fa-moon');
      } else {
        html.classList.add('dark');
        localStorage.setItem('theme', 'dark');
        if (themeIcon) themeIcon.classList.replace('fa-moon', 'fa-sun');
      }
    }

    if (themeToggle) {
      themeToggle.addEventListener('click', toggleTheme);
    }
  });
</script>
</body>
</html>