<?php
include 'include/header.php';

if (!isset($_SESSION['vendor_id']) || empty($_SESSION['vendor_id'])) {
    header("Location: vendor-login.php");
    exit();
}
$vendor_id = $_SESSION['vendor_id'];

// Get all transactions
$transactions = [];
$stmt = $conn->prepare("SELECT * FROM vendor_wallet_transactions 
                       WHERE vendor_id = ? 
                       ORDER BY created_at DESC");
$stmt->bind_param("s", $vendor_id);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $transactions[] = $row;
}
?>

<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-bold mb-6">Transaction History</h1>
    
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Reference</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (empty($transactions)): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">No transactions found</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($transactions as $txn): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap"><?= date('M j, Y g:i A', strtotime($txn['created_at'])) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?= $txn['transaction_type'] === 'debit' ? 'Withdrawal' : 'Deposit' ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap"><?= $txn['reference'] ?></td>
                        <td class="px-6 py-4 whitespace-nowrap 
                            <?= $txn['transaction_type'] === 'debit' ? 'text-red-500' : 'text-green-500' ?>">
                            <?= $txn['transaction_type'] === 'debit' ? '-' : '+' ?><?= number_format($txn['amount'], 2) ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?= $txn['status'] === 'completed' ? 'bg-green-100 text-green-800' : 
                                   ($txn['status'] === 'failed' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') ?>">
                                <?= ucfirst($txn['status']) ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'include/footer.php'; ?>