<?php
// register_vendor.php
require '../config/conn.php';
require '../config/session.php';

// Initialize error messages
$errors = [
    'business_name' => '',
    'email' => '',
    'contact_person' => '',
    'password' => '',
    'confirm_password' => '',
    'terms' => ''
];

// Retrieve form data from session if available
$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
$business_name = $form_data['business_name'] ?? '';
$email = $form_data['email'] ?? '';
$contact_person = $form_data['contact_person'] ?? '';

// If there are validation errors from form submission, display them
if (isset($_SESSION['validation_errors'])) {
    $errors = array_merge($errors, $_SESSION['validation_errors']);
    unset($_SESSION['validation_errors']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendor Portal - Registration</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        :root {
            --primary: #FBBB01;
            --primary-dark: #e0a800;
            --primary-light: #ffd54f;
            --text-primary: #1a202c;
            --text-secondary: #4a5568;
            --card-bg: #ffffff;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --error-color: #e53e3e;
            --success-color: #48bb78;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            transition: background-color 0.3s, color 0.3s, transform 0.3s;
        }

        body {
            font-family: 'Poppins', 'Helvetica', sans-serif;
            background-color: #ffffff;
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .error-text {
            color: var(--error-color);
            font-size: 0.8rem;
            margin-top: 5px;
            display: block;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes button-loading-spinner {
            from { transform: rotate(0turn); }
            to { transform: rotate(1turn); }
        }
        
        .portal-logo {
            max-height: 80px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="auth-container max-w-[1200px] w-full flex flex-col items-center">
        <div class="auth-header text-center mb-[30px]">
            <img src="path/to/your/portal-logo.png" alt="Vendor Portal Logo" class="portal-logo">
            <h1 class="text-[2.5rem] mb-[10px] bg-gradient-to-r from-[#FBBB01] to-[#ffd54f] bg-clip-text text-transparent">Vendor Portal</h1>
            <p class="text-[#4a5568] text-[1.1rem]">Register your business to start working with us</p>
        </div>

        <!-- Display session messages -->
        <?php 
        if (isset($_SESSION['success_message'])) {
            echo '<div class="form-message success-message w-full max-w-[500px] bg-[rgba(72,187,120,0.1)] text-[#48bb78] border-l-[3px] border-[#48bb78] px-[15px] py-[10px] rounded-[8px] mb-[20px]" style="display: block;">' . $_SESSION['success_message'] . '</div>';
            unset($_SESSION['success_message']);
        }
        
        if (isset($_SESSION['error_messages'])) {
            foreach ($_SESSION['error_messages'] as $error) {
                echo '<div class="form-message error-message w-full max-w-[500px] bg-[rgba(229,62,62,0.1)] text-[#e53e3e] border-l-[3px] border-[#e53e3e] px-[15px] py-[10px] rounded-[8px] mb-[20px]" style="display: block;">' . $error . '</div>';
            }
            unset($_SESSION['error_messages']);
        }
        ?>

        <form id="registerForm" class="auth-form active w-full max-w-[500px] bg-white rounded-[10px] p-[30px] shadow-[0_4px_6px_rgba(0,0,0,0.1)] border border-gray-200" action="process_vendor_register.php" method="POST">
            <div class="form-group mb-[20px]">
                <label for="businessName" class="block mb-[8px] font-[500] text-[#1a202c]">Business Name</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-building absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="text" id="businessName" name="business_name" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your business name" required value="<?php echo htmlspecialchars($business_name); ?>">
                </div>
                <?php if (!empty($errors['business_name'])): ?>
                    <small class="error-text"><?php echo $errors['business_name']; ?></small>
                <?php endif; ?>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerEmail" class="block mb-[8px] font-[500] text-[#1a202c]">Email Address</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-envelope absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="email" id="registerEmail" name="email" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter your email" required value="<?php echo htmlspecialchars($email); ?>">
                </div>
                <?php if (!empty($errors['email'])): ?>
                    <small class="error-text"><?php echo $errors['email']; ?></small>
                <?php endif; ?>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="contactPerson" class="block mb-[8px] font-[500] text-[#1a202c]">Contact Person</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-user absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="text" id="contactPerson" name="contact_person" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Enter contact person name" required value="<?php echo htmlspecialchars($contact_person); ?>">
                </div>
                <?php if (!empty($errors['contact_person'])): ?>
                    <small class="error-text"><?php echo $errors['contact_person']; ?></small>
                <?php endif; ?>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerPassword" class="block mb-[8px] font-[500] text-[#1a202c]">Password</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-lock absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="password" id="registerPassword" name="password" class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" 
                           placeholder="Create a password" required>
                    <i class="fas fa-eye password-toggle absolute right-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568] cursor-pointer" id="toggleRegisterPassword"></i>
                </div>
                <?php if (!empty($errors['password'])): ?>
                    <small class="error-text"><?php echo $errors['password']; ?></small>
                <?php endif; ?>
                <small class="text-[#4a5568] block mt-[5px]">
                    Must be at least 8 characters with one uppercase, one lowercase, one number, and one special character
                </small>
            </div>
            
            <div class="form-group mb-[20px]">
                <label for="registerConfirmPassword" class="block mb-[8px] font-[500] text-[#1a202c]">Confirm Password</label>
                <div class="input-wrapper relative">
                    <i class="fas fa-lock absolute left-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568]"></i>
                    <input type="password" id="registerConfirmPassword" name="confirm_password" 
                           class="form-control w-full px-[15px] py-[12px] pl-[40px] border border-gray-300 rounded-[8px] bg-white text-[#1a202c] font-['Poppins'] text-[1rem] focus:outline-none focus:border-[#FBBB01] focus:ring-1 focus:ring-[#FBBB01]" placeholder="Confirm your password" required>
                    <i class="fas fa-eye password-toggle absolute right-[15px] top-[50%] transform -translate-y-1/2 text-[#4a5568] cursor-pointer" id="toggleConfirmPassword"></i>
                </div>
                <?php if (!empty($errors['confirm_password'])): ?>
                    <small class="error-text"><?php echo $errors['confirm_password']; ?></small>
                <?php endif; ?>
            </div>
            
            <div class="form-group mb-[20px]">
                <input type="checkbox" id="acceptTerms" name="accept_terms" required class="mr-[8px]">
                <label for="acceptTerms" class="text-[#1a202c]">I agree to the <a href="terms.php" class="text-[#FBBB01] hover:underline">Terms of Service</a> and <a href="privacy.php" class="text-[#FBBB01] hover:underline">Privacy Policy</a></label>
                <?php if (!empty($errors['terms'])): ?>
                    <small class="error-text"><?php echo $errors['terms']; ?></small>
                <?php endif; ?>
            </div>
            
            <button type="submit" class="btn w-full py-[12px] bg-[#FBBB01] text-white border-none rounded-[8px] font-['Poppins'] text-[1rem] font-[500] cursor-pointer hover:bg-[#e0a800] mt-[20px] relative transition-colors duration-300" id="submitBtn" name="register">
                <span class="btn-text">Register Business</span>
            </button>
            
            <div class="auth-switch text-center text-[#4a5568] mt-[20px]">
                Already have an account? <a href="login.php" class="text-[#FBBB01] no-underline ml-[5px] hover:underline">Sign in</a>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Password Toggle Visibility
            function setupPasswordToggle(toggleId, inputId) {
                const toggle = document.getElementById(toggleId);
                const input = document.getElementById(inputId);
                
                toggle.addEventListener('click', function() {
                    if (input.type === 'password') {
                        input.type = 'text';
                        toggle.classList.remove('fa-eye');
                        toggle.classList.add('fa-eye-slash');
                    } else {
                        input.type = 'password';
                        toggle.classList.remove('fa-eye-slash');
                        toggle.classList.add('fa-eye');
                    }
                });
            }
            
            setupPasswordToggle('toggleRegisterPassword', 'registerPassword');
            setupPasswordToggle('toggleConfirmPassword', 'registerConfirmPassword');
        });
    </script>
</body>
</html>
<?php
// Clear form data from session after displaying it
if (isset($_SESSION['form_data'])) {
    unset($_SESSION['form_data']);
}
?>